//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 9: Heat Transfer in Boiling and Other Phase Change Configurations
//Example: 9.7 Page 489
//Title: Rapid Rate of Removal of Heat
//======================================================
model Ex9_7

//==========
//Parameter Section

parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to Gravity";
parameter Real sigma(unit = "N/m") = 0.0589 "Surface Tension of Water";
parameter Real hfg(unit = "J/kg") = 2257e3 "Latent Heat of Vapourization of Water";

//==========
//Variable Section

input Real rhof(unit = "kg/m^3",start = 958) "Density of Water";
input Real rhog(unit = "kg/m^3",start = 0.597) "Density of Gas";
input Real A(unit = "m^2",start = 400e-4) "Surface Area of the Body";
input Real V(unit = "m^3",start = 600e-6) "Volume of the Body";
output Real Q(unit = "W") "Rate of Removal of Heat";
Real qmax(unit = "W/m^2") "Maximum Heat Flux";
Real R "Constant";

//==========
//Equation Section

equation
qmax = 0.9*0.131*(rhog^0.5)*hfg*((g*(rhof-rhog)*sigma)^0.25);
//Refer Table 9.3 Equation 9.25 Page 488
Q = qmax*A;
R = (V/A)/((sigma/(g*(rhof-rhog)))^0.5);
//The Value of R = 5.99, which is greater than 4. Therefore the Body can be classified to be Large.
end Ex9_7;
//======================================================
