//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 1: Introduction
//Example: 1.5 Page 32
//Title: Temperature of the Black Thermocouple
//======================================================
model Ex1_5

//==========
//Parameter Section

parameter Real sigma(unit = "W/((m^2)(K^4))") = 5.67e-8 "Stefan-Boltzmann Constant";
parameter Real h(unit = "W/(m^2 K)") = 75 "Heat Transfer Coefficient between the Black Thermocouple and Air";

//==========
//Variable Section

input Real Tair(unit = "deg C",start = 20) "Temperature of Air";
input Real Twall(unit = "deg C",start = 100) "Temperature of the Wall of the Black Thermocouple";
output Real Ttc(unit = "deg C") "Temperature of the Black Thermocouple";

//==========
//Equation Section

equation
h*(Ttc-Tair) = sigma*(((Twall+273)^4)-((Ttc+273)^4));         //Refer Page 33
end Ex1_5;
//======================================================
