//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 1: Introduction
//Example: 1.6 Page 33
//Title: Temperature of the Thermocouple
//======================================================
model Ex1_6

//==========
//Parameter Section

parameter Real sigma(unit = "W/((m^2)(K^4))") = 5.67e-8 "Stefan-Boltzmann Constant";
parameter Real h(unit = "W/(m^2 K)") = 75 "Heat Transfer Coefficient between the Thermocouple and Air";
parameter Real etc = 0.4 "Emittance of the Thermocouple";

//==========
//Variable Section

input Real Tair(unit = "deg C",start = 20) "Temperature of Air";
input Real Twall(unit = "deg C",start = 100) "Temperature of the Wall of the Thermocouple";
output Real Ttc(unit = "deg C") "Temperature of the Thermocouple";

//==========
//Equation Section

equation
h*(Ttc-Tair) = sigma*etc*(((Twall+273)^4)-((Ttc+273)^4));         //Refer Page 34
end Ex1_6;
//======================================================
//Remarks: All the necessary data are taken from Example 1.5 (Page 32) as stated in the problem
