//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 10: Radiative Heat Transfer
//Example: 10.1 Page 543
//Title: Net Heat Transfer
//======================================================
model Ex10_1

//==========
//Parameter Section

parameter Real sigma(unit = "W/(m^2 K^4)") = 5.67e-8 "Stefan-Boltzmann Constant";

//==========
//Variable Section

input Real Tj(unit = "deg C",start = 2000) "Temperature of the Liquid Metal";
input Real Ts(unit = "deg C",start = 700) "Temperature of the Shield";
input Real Tr(unit = "deg C",start = 30) "Temperature of the Room";
input Real dc(unit = "m",start = 3e-3) "Diameter of the Crucible";
input Real ds(unit = "m",start = 5e-2) "Diameter of the Cylindrical Radiation Shield";
input Real t1(unit = "deg",start = 330) "Angle Between the Jet and the Shield";
input Real t2(unit = "deg",start = 30) "Angle of the Slit";
output Real Qjr(unit = "W/m") "Net Heat Transfer between the Jet and the Room";
output Real Qjs(unit = "W/m") "Net Heat Transfer between the Jet and Shield";
output Real Qsr(unit = "W/m") "Net Heat Transfer between the inside of the Shield to the Room";
Real Aj(unit = "m^2") "Area of the Jet";
Real As(unit = "m^2") "Area of the Shield";
Real Ast(unit = "m^2") "Area of the Slit";
Real Fjr "View Factor between the Jet and the Room";
Real Fjs "View Factor between the Jet and the Shield";
Real Fsr "View Factor between the Shield and the Room";
Real Fss "View Factor between the Slit and the Shield";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);
Aj = pi*dc;
Ast = ds*sin(pi/12);
As = pi*ds*t1/360;
Fjr = t2/360;
Fjs = t1/360;
Fss = 1-((pi*dc)*Fjr/Ast);
Fsr = (Ast/As)*Fss;
Qjr = Aj*Fjr*sigma*(((Tj+273)^4)-((Tr+273)^4));
Qjs = Aj*Fjs*sigma*(((Tj+273)^4)-((Ts+273)^4));
Qsr = As*Fsr*sigma*(((Ts+273)^4)-((Tr+273)^4));
end Ex10_1;
//======================================================
