//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 10: Radiative Heat Transfer
//Example: 10.11 Page 577
//Title: Net Heat Radiated
//======================================================
model Ex10_11

//==========
//Parameter Section

parameter Real sigma(unit = "W/(m^2 K^4)") = 5.67e-8 "Stefan Boltzmann Constant";

//==========
//Variable Section

input Real d(unit = "m",start = 40e-2) "Diameter of the Combuster";
input Real Tg(unit = "K",start = 1473) "Temperature of the Gas";
input Real Tw(unit = "K",start = 573) "Temperature of the Walls";
input Real pN2(unit = "atm",start = 0.8) "Partial Pressure of Nitrogen";
input Real pCO2(unit = "atm",start = 0.2) "Partial Pressure of Carbon Dioxide";
output Real Qnet(unit = "kW/m") "Net Heat Radiated";
Real e "Emissivity";
Real a "Absorptivity";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);
e = 0.098;      //From Fig. 10.23 Page 576
a = ((Tg/Tw)^0.5)*0.074;
Qnet*1000 = pi*d*sigma*((e*(Tg^4))-(a*(Tw^4)));
end Ex10_11;
//======================================================
