//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 10: Radiative Heat Transfer
//Example: 10.2 Page 546
//Title: Net Heat Transfer from Heater to Shield
//======================================================
model Ex10_2

//==========
//Parameter Section

parameter Real sigma(unit = "W/(m^2 K^4)") = 5.67e-8 "Stefan-Boltzmann Constant";

//==========
//Variable Section

input Real Th(unit = "deg C",start = 1200) "Temperature of the Heater";
input Real Ts(unit = "deg C",start = 100) "Temperature of the Shield";
input Real d1(unit = "m",start = 0.1) "Diameter of the Bottom End";
input Real d2(unit = "m",start = 0.2) "Diameter of the Top End";
input Real l(unit = "m",start = 0.2) "Height of the Heater";
output Real Qhs(unit = "W") "Net Heat Transfer From the Heater to the Shield";
Real Ah(unit = "m^2") "Area of the Heater";
Real Fhs "View Factor between the Heater and the Shield";
Real X "Size Ratio";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);
Ah = pi*(d1^2)/4;
X = 1+((1+((d2/(2*l))^2))/((d1/(2*l))^2));
Fhs = 1-0.5*(X-(((X^2)-4*((d2/d1)^2))^0.5));
//Refer Table 10.3 Page 548
Qhs = Ah*Fhs*sigma*(((Th+273)^4)-((Ts+273)^4));
end Ex10_2;
//======================================================
