//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 10: Radiative Heat Transfer
//Example: 10.3 Page 551
//Title: View Factor between Shield and Heater
//======================================================
model Ex10_3

//==========
//Variable Section

input Real d1(unit = "m",start = 0.1) "Diameter of the Bottom End";
input Real d2(unit = "m",start = 0.2) "Diameter of the Top End";
input Real l(unit = "m",start = 0.2) "Height of the Heater";
output Real Fsh "View Factor between the Shield and the Heater";
Real Fhs "View Factor between the Heater and the Shield";
Real As(unit = "m^2") "Area of the Shield";
Real Ah(unit = "m^2") "Area of the Heater";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);
As = pi*((d1+d2)/2)*(((l^2)+(((d2/2)-(d1/2))^2))^0.5);
Ah = pi*((d2/2)^2)/4;
Fhs = 0.808;       //Value of Fhs is taken from Example 10.2
Fsh*As = Fhs*Ah;
end Ex10_3;
//======================================================
