//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 10: Radiative Heat Transfer
//Example: 10.8 Page 558
//Title: Temperature of Shield
//======================================================
model Ex10_8

//==========
//Parameter Section

parameter Real sigma(unit = "W/(m^2 K^4)") = 5.67e-8 "Stefan Boltzmann Constant";

//==========
//Variable Section

input Real e(start = 0.2) "Emissivity";
input Real Tn(unit = "K",start = 80) "Temperature of Nitrogen";
input Real Tw(unit = "K",start = 230) "Temperature of the Chamber Walls";
input Real d1(unit = "m",start = 6.35e-3) "Diameter of the First Stainless Steel Line";
input Real d2(unit = "m",start = 12.7e-3) "Diameter of the Second Stainless Steel Line";
output Real Qg(unit = "W/m") "Rate of Heat Gain without Shield";
output Real Qgs(unit = "W/m") "Rate of Heat Gain with Shield";
output Real Ts(unit = "K") "Temperature of the Shield";
output Real r(unit = "%") "Percent Reduction in Rate of Heat Gain";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);
Qg = pi*d1*e*sigma*((Tw^4)-(Tn^4));
Qgs = (pi*d1*sigma*((Tw^4)-(Tn^4)))/((((1-e)/e)+1)+((d1/d2)*(2*((1-e)/e)+1)));
r = ((Qg-Qgs)/Qg)*100;
Qgs = pi*d2*e*sigma*((Tw^4)-(Ts^4));
end Ex10_8;
//======================================================
