//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 10: Radiative Heat Transfer
//Example: 10.9 Page 561
//Title: Net Heat Transfer
//======================================================
//Remark
//3 denotes the Reflector

model Ex10_9

//==========
//Parameter Section

parameter Real sigma(unit = "W/(m^2 K^4)") = 5.67e-8 "Stefan Boltzmann Constant";

//==========
//Variable Section

input Real d1(unit = "m",start = 1) "Width of the First Strip";
input Real d2(unit = "m",start = 2.40) "Width of the Second Strip";
output Real Qnet(unit = "W/m") "Net Heat Transfer without the Reflector";
output Real Qnetr(unit = "W/m") "Net Heat Transfer with the Reflector";
output Real T3(unit = "K") "Temperature of Reflector";
Real F12  "View Factor Corresponding to Strips 1 and 2";
Real F23 "View Factor Corresponding to Strips 2 and 3";
Real B1(unit = "W/m^2") "Heat Transfer from Node 1";
Real B2(unit = "W/m^2") "Heat Transfer from Node 2";
Real B3(unit = "W/m^2") "Heat Transfer from Node 3";
Real T1(unit = "K") "Temperature at Node 1";
Real T2(unit = "K") "Temperature at Node 2";
Real e1 "Emissivity at Node 1";
Real e2 "Emissivity at Node 2";

//==========
//Equation Section

equation
F12 = 0.2;          //Refer Table 10.2 Page 547
F23 = 0.8;
e1 = 0.3;
e2 = 0.5;
T1 = 400;
T2 = 300;
((1451-B1)/d2) = ((B1-B2)/(1/F12))+((B1-B3)/(1/F23));
((459.3-B2)/d1) = ((B2-B1)/(1/F12))+((B2-B3)/(1/F23));
((B3-B1)/(1/F23))+((B3-B2)/(1/F23)) = 0;
Qnet = ((B1-B2)/(1/F12))+((B1-B3)/(1/F23));
Qnetr = (sigma*((T1^4)-(T2^4)))/(((1-e1)/e1)+(1/(1/((1/F23)+(1/F23))+F12))+((1-e2)/e2));
B3 = sigma*(T3^4);
end Ex10_9;
//======================================================
