//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 11: An Introduction to Mass Transfer
//Example: 11.15 Page 661
//Title: Rate of Evaporation
//======================================================
model Ex11_15

//==========
//Parameter Section

parameter Real Patm(unit = "kPa") = 101.325 "Atmospheric Pressure";
parameter Real Mw(unit = "kg/kgmol") = 18 "Molecular Weight of Water";
parameter Real Mair(unit = "kg/kgmol") = 28.96 "Molecular Weight of Air";

//==========
//Variable Section

input Real Tw(unit = "K",start = 348) "Temperature of Water";
input Real gma(unit = "kg/(m^2 s)",start = 0.0169) "Average Mass Transfer Coefficient for Water over the Pan";
input Real Ap(unit = "m^2",start = 0.04) "Surface Area of the Pan";
input Real mw1(start = 0.05) "Mass Fraction of Water in the Stream";
output Real mwe(unit = "kg/s") "Rate of Evaporation";
Real mw2 "Mass Fraction of Water Vapour";
Real pw(unit = "kPa") "Vapour Pressure of Water Vapour";
Real Bw "Mass Transfer Driving Force";
Real xw "Mole Fraction of Water Vapour";

//==========
//Equation Section

equation
pw = 38.58;     //From Steam Tables
xw = pw/Patm;
mw2 = (xw*Mw)/((xw*Mw)+((1-xw)*Mair));
Bw = (mw1-mw2)/(mw2-1);
mwe = gma*Bw*Ap;
end Ex11_15;
//======================================================
