//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 11: An Introduction to Mass Transfer
//Example: 11.6 Page 638
//Title: Mass Fraction of Water Vapour Above Surface of Ice
//======================================================
model Ex11_6

//==========
//Parameter Section

parameter Real Mw(unit = "kg/kgmol") = 18 "Molecular Weight of Water";
parameter Real Mair(unit = "kg/kgmol") = 28.96 "Molecular Weight of Air";

//==========
//Variable Section

input Real Ti(unit = "K",start = 263) "Temperature of Ice";
input Real Pa(unit = "kPa",start = 101.325) "Pressure exerted by Air";
output Real mw "Mass Fraction of Water Vapour above the Surface of Ice";
Real xw "Mole Fraction of Water Vapour";
Real pw(unit = "kPa") "Vapour Pressure of Water Vapour";

//==========
//Equation Section

equation
log(pw) = 21.99-(6141/Ti);      //Refer Page 638
xw = pw/Pa;
mw = (xw*Mw)/((xw*Mw)+((1-xw)*Mair));
end Ex11_6;
//======================================================
