//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 2: Heat Conduction Concepts, Thermal Resistance, and the Overall Heat Transfer Coefficient
//Example: 2.9 Page 79
//Title: Thickness of Stainless Steel Slabs
//======================================================
model Ex2_9

//==========
//Parameter Section

parameter Real K(unit = "W/(m K)",start = 18) "Thermal Conductivity of Stainless Steel";
parameter Real hss(unit = "W/(m^2 K)") = 3000 "Convective Heat Transfer Coefficient of Stainless Steel";  
//Refer Table 2.1 Page 78

//==========
//Variable Section

input Real A(unit = "m^2",start = 1) "Area of the Stainless Steel Slabs";
output Real l(unit = "m") "Thickness of the Stainless Steel Slabs";

//==========
//Equation Section

equation
2*l/18 = 1/hss;
//2*l/18 should be very much greater than 1/hss for the Contact Resistance between the two Slabs to be neglected. Therefore the thickness of the Slabs should be greater than that obtained by the above Equation. As far as this problem is concerned, the value of l obtained by the above equation is, l = 0.003 m. Therefore the value of l should be greater than, l = 0.03 m for the Contact Resistance to be ignored.
end Ex2_9;
//======================================================
