//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 3: Heat Exchanger Design
//Example: 3.3 Page 115
//Title: Heat Transfer Coefficient and Mass Flow Rate of Water
//======================================================
model Ex3_3

//==========
//Parameter Section

parameter Real hfg(unit = "kJ/kg") = 2358.7 "Latent Heat of Water at 60 deg C";
parameter Real cp(unit = "J/(kg K)") = 4174 "Specific Heat Capacity of Water";

//==========
//Variable Section

input Real Te(unit = "deg C",start = 20) "Temperature of Water Entering the Tubes of the Heat Exchanger";
input Real Tl(unit = "deg C",start = 40) "Temperature of Water Leaving the Tubes of the Heat Exchanger";
input Real Ts(unit = "deg C",start = 60) "Temperature at which the Steam Condenses";
input Real ms(unit = "kg/min",start = 25) "Mass Flow Rate of Steam (Condensate) on the Shell Side of the Heat Exchanger";
input Real A(unit = "m^2",start = 12) "Area of the Heat Exchanger";
output Real U(unit = "W/(m^2 K)") "Overall Heat Transfer Coefficient";
output Real mw(unit = "kg/s") "Mass Flow Rate of Water";
Real Q(unit = "kJ/s") "Rate of Heat Transfer";
Real LMTD(unit = "K") "Log Mean Temperature Difference";

//==========
//Equation Section

equation
Q = ms*hfg/60;      //1 min = 60 s
LMTD = ((Ts-Te)-(Ts-Tl))/(log((Ts-Te)/(Ts-Tl)));                 //Refer Page 115
U = Q*1000/(A*LMTD);      //1 kJ/s = 1000 J/s
mw = Q*1000/(cp*(Tl-Te));
end Ex3_3;
//======================================================
