//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 5: Transient and Multidimensional Heat Conduction
//Example: 5.11 Page 246
//Title: Thermal Conductivity of Soil Sample
//======================================================
model Ex5_11

//==========
//Variable Section

input Real Q(unit = "W",start = 14) "Steady State Heat Transfer Rate";
input Real d(unit = "m",start = 6e-2) "Diameter of the Spherical Heat Source";
input Real h(unit = "m",start = 30e-2) "The Depth at which the Spherical Heat Source is Placed under the Box of Soil";
input Real Th(unit = "deg C",start = 35) "Temperature of the Spherical Heat Source";
input Real Ts(unit = "deg C",start = 21) "Temperature of the Surface of the Soil";
output Real K(unit = "W/(m K)") "Thermal Conductivity of the Soil Sample";
Real pi "Constant";

//==========
//Equation Section

equation
pi=2*Modelica.Math.asin(1.0);                 //Constant pi
Q = (4*pi*(d/2))/(1-(d/(4*h)))*K*(Th-Ts);     //Refer Page 246
end Ex5_11;
//======================================================
