//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 5: Transient and Multidimensional Heat Conduction
//Example: 5.8 Page 241
//Title: Temperature in the Middle of Wall
//======================================================
model Ex5_8

//==========
//Parameter Section

parameter Real K(unit = "W/(m K)") = 0.12 "Thermal Conductivity of the Insulating Material";

//==========
//Variable Section

input Real T1(unit = "deg C",start = 40) "Temperature of the First Wall";
input Real T2(unit = "deg C",start = 0) "Temperature of the Ribs";
output Real Q(unit = "W/m") "Heat Flux through the Wall";
output Real Tm(unit = "deg C") "Temperature in the Middle of the Wall";
Real N "Number of Heat Flow Channels";
Real I "Number of Isothermal Increments";

//==========
//Equation Section

equation
//The Values of N and I are taken from the Graph (Figure 5.23) in Page 243
N = 6.15;
I = 5.6;
Q = 2*(N*K*(T1-T2))/I;
Tm = (2.16/I)*(T1-T2);          //Refer Page 241
end Ex5_8;
//======================================================
