//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 5: Transient and Multidimensional Heat Conduction
//Example: 5.9 Page 244
//Title: Shape Factor of a One Quarter Section of a Thick Cylinder
//======================================================
model Ex5_9

//==========
//Variable Section

Real Rr "Radius Ratio, Rr = ro/ri";
output Real S "Shape Factor of the One-Quarter Section of a Thick Cylinder ";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);  //Constant pi
Rr = 3;                          //Refer Figure 5.24 in Page 244
S = pi/(2*log(Rr));              //Refer Page 244
end Ex5_9;
//======================================================
