//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 6: Laminar and Turbulent Boundary Layers
//Example: 6.3 Page 292
//Title: Average Shear Stress and Overall Friction Coefficient
//======================================================
model Ex6_3

//==========
//Parameter Section

parameter Real rho(unit = "kg/m^3") = 1.183 "Density of Air";
parameter Real nu(unit = "m^2/s") = 1.566e-5 "Kinematic Viscosity of Air";

//==========
//Variable Section

input Real l(unit = "m",start = 0.5) "Total Length of the Surface";
output Real Cf "Overall Skin Friction Coefficient";
output Real tauw(unit = "N/m^2") "Shear Stress";
output Real tauwa(unit = "N/m^2") "Average Shear Stress over the Length of the Surface";
output Real x1(unit = "m") "Distance at which Local Shear Stress equals Average Shear Stress";
output Real x2(unit = "m") "Length of the Surface till which the Boundary Layer Analysis is valid";
Real Re "Reynolds Number";
Real uair(unit = "m/s") "Velocity of Air";
Real k "x1/L";
Real f(unit = "%") "Fraction of the Surface in which Boundary Layer Analysis is Valid";

//==========
//Equation Section

equation
Re = 47892.7;             //Refer Example 6.2
Cf = 1.328/(Re^0.5);      //Refer Page 292
uair = 1.5;               //Refer Example 6.2
tauwa = (rho*(uair^2)*Cf)/2;
tauw/tauwa = (0.664/(Re^0.5))/(1.328/(Re^0.5));
0.664/(x1^0.5) = 1.328/(0.5^0.5);
k = x1/l;
x2 = 600*nu/uair;
f = ((l-x2)/l)*100;
end Ex6_3;
//======================================================
