//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 6: Laminar and Turbulent Boundary Layers
//Example: 6.4 Page 297
//Title: Average Heat Flux
//======================================================
model Ex6_4

//==========
//Parameter Section

parameter Real nu(unit = "m^2/s") = 1.725e-7 "Kinematic Viscosity of Water at Mean Film Temperature";
parameter Real alpha(unit = "m^2/s") = 1.724e-7 "Thermal Diffusivity of water at Mean Film Temperature";
parameter Real K(unit = "W/(m K)") = 0.674 "Thermal Conductivity of Water at Mean Film Temperature";

//==========
//Variable Section

input Real l(unit = "m",start = 0.06) "Length of the Flat Heater";
input Real Tw(unit = "K",start = 440) "Temperature of Water";
input Real Th(unit = "K",start = 460) "Temperature of the Heater";
input Real u(unit = "m/s",start = 2) "Free Stream Velocity";
output Real qa(unit = "kW/m^2") "Average Heat Flux";
Real Tf(unit = "K") "Mean Film Temperature";

//==========
//Equation Section

equation
Tf = (Tw+Th)/2;
qa*1000 = 2*0.332*(K/l)*(((2*l)/nu)^0.5)*(Th-Tw);
//Refer Page 298
end Ex6_4;
//======================================================
