//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 6: Laminar and Turbulent Boundary Layers
//Example: 6.5 Page 310
//Title: Average Heat Transfer Coefficient and Total Heat Transferred by Air
//======================================================
model Ex6_5

//==========
//Parameter Section

parameter Real Pr = 0.707 "Prandtl Number at Mean Film Temperature";
parameter Real K(unit = "W/(m K)") = 0.02885 "Thermal Conductivity of Air at Mean Film Temperature";
parameter Real nu(unit = "m^2/s") = 0.0000194 "Kinematic Viscosity of Air at Mean Film Temperature";

//==========
//Variable Section

input Real Tair(unit = "deg C",start = 20) "Temperature of Air";
input Real Tp(unit = "deg C",start = 110) "Temperature of an Isothermal Steam-Heated Plate";
input Real uair(unit = "m/s",start = 15) "Velocity of Air";
input Real l(unit = "m",start = 0.5) "Length of the Plate";
input Real b(unit = "m",start = 0.5) "Breadth or Width of the Plate";
output Real ha(unit = "W/(m^2 K)") "Average Heat Transfer Coefficient";
output Real Q(unit = "W") "Total Heat Transferred";
output Real delta(unit = "m") "Flow Boundary Layer Thickness";
output Real deltat(unit = "m") "Thermal Boundary Layer Thickness";
output Real hte(unit = "W/(m^2 K)") "Heat Transfer Coefficient at the Trailing Edge";
Real A(unit = "m^2") "Area of the Plate";
Real Re "Reynolds Number";
Real Nu "Nusselt's Number";

//==========
//Equation Section

equation
Re = (uair*l)/nu;     //Reynolds Number Calculation
Nu = 0.664*(Re^0.5)*(Pr^(1/3));     //Refer Page 310
ha = (Nu*K)/l;
A = 0.5*0.5;      //Area of the Plate
Q = ha*A*(Tp-Tair);
hte = ha/2;
delta = (4.92*l)/(Re^0.5);    //Flow Boundary Layer Thickness 
deltat = delta/(Pr^(1/3));//Thermal Boundary Layer Thickness
end Ex6_5;
//======================================================
