//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 6: Laminar and Turbulent Boundary Layers
//Example: 6.6 Page 312
//Title: Average Temperature of Plate
//======================================================
model Ex6_6

//==========
//Parameter Section

parameter Real K(unit = "W/(m K)") = 0.0278 "Thermal Conductivity of Air at Mean Film Temperature";
parameter Real nu(unit = "m^2/s") = 1.794e-5 "Kinematic Viscosity of Air at Mean Film Temperature";
parameter Real Pr = 0.709 "Prandtl Number of Air at Mean Film Temperature";

//==========
//Variable Section

input Real Tair(unit = "deg C",start = 15) "Temperature of Air";
input Real uair(unit = "m/s",start = 1.8) "Velocity of Air";
input Real l(unit = "m",start = 0.6) "Length of the Heating Panel or Plate";
input Real q(unit = "W/m^2",start = 420) "Heat Flux of the Plate";
output Real Tap(unit = "deg C") "Average Temperature of the Plate";
Real Tmax(unit = "deg C") "Maximum Temperature the Surface of the Plate can Handle without getting Damaged";
Real Re "Reynolds Number";

//==========
//Equation Section

equation
Re = l*uair/nu;                 //Reynolds Number Calculation
Tmax = Tair+((q*l/K)/(0.453*(Re^0.5)*(Pr^(1/3))));
//The Maximum Temperature that the Plate can Handle without getting Damaged is, Tmax = 106.462 deg C. Tmax > 105 deg C. Therefore it is Safe to maintain the Temperature of Surface of the Plate at 105 deg C without damaging it.
Tap = Tair+((0.453/0.6795)*(Tmax-Tair));
end Ex6_6;
//======================================================
