//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 6: Laminar and Turbulent Boundary Layers
//Example: 6.9 Page 329
//Title: Skin Friction Coefficient and Heat Transfer Coefficient at Edge of Hull
//======================================================
model Ex6_9

//==========
//Parameter Section

parameter Real nu(unit = "m^2/s") = 1.085e-6 "Kinematic Viscosity of water at Mean Film Temperature";
parameter Real K(unit = "W/(m K)") = 0.5927 "Thermal Conductivity of Water at Mean Film Temperature";
parameter Real rho(unit = "kg/m^3") = 998.8 "Density of Water at Mean Film Temperature";
parameter Real cp(unit = "J/(kg K)") = 4187 "Specific Heat Capacity of Water at Mean Film Temperature";
parameter Real Pr = 7.66 "Prandtl Number of Water at Mean Film Temperature";

//==========
//Variable Section

input Real Trw(unit = "deg C",start = 24) "Temperature of River Water";
input Real Tow(unit = "deg C",start = 10) "Temperature of Ocean Water";
input Real us(unit = "knots",start = 5) "Velocity of the Ship";
input Real x(unit = "m",start = 1) "Distance from the Forward Edge of the Hull";
output Real Cf "Skin Friction Coefficient at the Point of Interest";
output Real h(unit = "W/(m^2 K)") "Heat Transfer Coefficient at the Point of Interest";
Real Tf(unit = "deg C") "Mean Film Temperature";
Real Re "Reynolds Number";
Real Nu "Nusselt's Number";

//==========
//Equation Section

equation
Tf = (Trw+Tow)/2;
Re = (x*us*0.5144)/nu;               //1 knot = 0.5144 m/s
Cf = 0.455/((log(0.06*Re))^2);
Nu = 0.032*(Re^0.8)*(Pr^0.43);      //Refer Page 330
h = (K*Nu)/x;
//Heat Transfer Coefficient at the Point of Interest can also be found out by using the Formula,
//h = rho*cp*us*(((Cf/2)^0.5)/(1+12.8*((Pr^0.68)-1)))
//The above Formula yields the value, h = 6843 W/(m^2 K). The two values of the Heat Transfer Coefficient, h differs approximately by 19%
end Ex6_9;
//======================================================
