//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 7: Forced Convection in a Variety of Configurations
//Example: 7.3 Page 363
//Title: Turbulent Water Flow in a Smooth Pipe
//======================================================
model Ex7_3

//==========
//Parameter Section

parameter Real rho(unit = "kg/m^3") = 977 "Density of Water at Mean Film Temperature";
parameter Real nu(unit = "m^2/s") = 4.07e-7 "Kinematic Viscosity of Water at Mean Film Temperature";
parameter Real Pr = 2.47 "Prandtl Number of Water at Mean Film Temperature";
parameter Real K(unit = "W/(m K)") = 0.661 "Thermal Conductivity of Water at Mean Film Temperature";
parameter Real mub(unit = "kg/(m s)") = 5.38e-4 "Dynamic Viscosity of Water at Bulk Temperature";
parameter Real muw(unit = "kg/(m s)") = 3.10e-4 "Dynamic Viscosity of Water at wall Temperature";

//==========
//Variable Section

input Real m(unit = "kg/s",start = 21.5) "Mass Flow Rate of Water in the Pipe";
input Real d(unit = "m",start = 12e-2) "Diameter of the Pipe";
input Real Tp(unit = "deg C",start = 90) "Wall Temperature of the Pipe";
input Real Tw(unit = "deg C",start = 50) "Bulk Temperature of Water";
output Real h(unit = "W/(m^2 K)") "Heat Transfer Coefficient";
output Real f "Friction Factor";
Real u(unit = "m/s") "Velocity of Water through the Pipe";
Real Re "Reynolds Number";
Real Nu "Nusselt's Number";
Real mur "Ratio of mub to muw";
Real fbt "Friction Factor at Bulk Temperature";
Real pi "Constant";

//==========
//Equation Section

equation
pi=2*Modelica.Math.asin(1.0);         //Constant pi
u = m/(rho*pi*d*d/4);
Re = (u*d)/nu;
mur = mub/muw;
fbt = ((1.82*log10(Re))-1.64)^(-2);   //Refer Page 362
Nu = ((fbt/8)*Re*Pr*(mur^0.11))/(1.07+12.7*((fbt/8)^0.5)*((Pr^(2/3))-1));              //Refer Page 362
h = Nu*K/d;
f = 0.0128*(7-mur)/6;                 //Refer Page 363
end Ex7_3;
//======================================================
