//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 7: Forced Convection in a Variety of Configurations
//Example: 7.4 Page 366
//Title: Turbulent Water Flow in Rough Pipe
//======================================================
model Ex7_4

//==========
//Parameter Section

parameter Real rho(unit = "kg/m^3") = 977 "Density of Water at Mean Film Temperature";
parameter Real nu(unit = "m^2/s") = 4.07e-7 "Kinematic Viscosity of Water at Mean Film Temperature";
parameter Real Pr = 2.47 "Prandtl Number of Water at Mean Film Temperature";
parameter Real K(unit = "W/(m K)") = 0.661 "Thermal Conductivity of Water at Mean Film Temperature";

//==========
//Variable Section

input Real m(unit = "kg/s",start = 21.5) "Mass Flow Rate of Water in the Pipe";
input Real d(unit = "m",start = 12e-2) "Diameter of the Pipe";
input Real Tp(unit = "deg C",start = 90) "Wall Temperature of the Pipe";
input Real Tw(unit = "deg C",start = 50) "Bulk Temperature of Water";
input Real e(unit = "m",start = 260e-6) "Roughness of the Pipe";
output Real h(unit = "W/(m^2 K)") "Heat Transfer Coefficient";
output Real f "Friction Factor";
Real u(unit = "m/s") "Velocity of Water through the Pipe";
Real Re "Reynolds Number";
Real Ree "Roughness Reynolds Number";
Real Nu "Nusselt's Number";
Real pi "Constant";

//==========
//Equation Section

equation
pi=2*Modelica.Math.asin(1.0);               //Constant pi
u = m/(rho*pi*d*d/4);
Re = (u*d)/nu;
f = (1.8*log10(((6.9/Re)+((e/d)/3.7))^1.11))^(-2);
Ree = Re*(e/d)*((f/8)^0.5);                 //Refer Page 364
Nu = ((f/8)*Re*Pr)/(1+(((f/8)^0.5)*((4.5*(Ree^0.2)*(Pr^0.5))-8.48)));  //Refer Page 365
h = Nu*K/d;
end Ex7_4;
//======================================================
