//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 7: Forced Convection in a Variety of Configurations
//Example: 7.6 Page 373
//Title: Bulk Temperature Change of Air
//======================================================
model Ex7_6

//==========
//Parameter Section

parameter Real nu(unit = "m^2/s") = 1.578e-5 "Kinematic Viscosity of Air";
parameter Real K(unit = "W/(m K)") = 0.02623 "Thermal Conductivity of Air";
parameter Real rho(unit = "kg/m^3") = 1.217 "Density of Air";
parameter Real Cp(unit = "J/(kg K)") = 1007 "Specific Heat Capacity of Air";
parameter Real Pr = 0.713 "Prandtl Number of Air";

//==========
//Variable Section

input Real Tai(unit = "deg C",start = 17) "Inlet Bulk Temperature of Air";
input Real Tw(unit = "deg C",start = 37) "Temperature of Warm Air";
input Real u(unit = "m/s",start = 1) "Velocity of Air through the Duct";
input Real w(unit = "m",start = 0.3) "Width of the Cross-Section of the Duct";
input Real b(unit = "m",start = 0.3) "Breadth of the Cross-Section of the Duct";
input Real l(unit = "m",start = 15) "Length of the Duct";
input Real hc(unit = "W/(m^2 K)",start = 5) "Heat Transfer Coefficient due to Natural Convection on the Outer Surface";
input Real hr(unit = "W/(m^2 K)",start = 5) "Heat Transfer Coefficient due to Thermal Radiation on the Outer Surface";
output Real Tbo(unit = "deg C") "Outer Bulk Temperature";
output Real delTb(unit = "deg C") "Change in Bulk Temperature of Air over the Duct";
Real h(unit = "W/(m^2 K)") "Heat Transfer Coefficient";
Real U(unit = "W/(m^2 K)") "Overall Heat Transfer Coefficient";
Real Re "Reynolds Number";
Real Nu "Nusselt's Number";
Real f "Friction Factor";

//==========
//Equation Section

equation
Re = u*b/nu;  //Hydraulic Diameter, Dh = b since w = b
f = ((1.82*log10(Re))-1.64)^(-2);
Nu = ((f/8)*(Re-1000)*Pr)/(1+(12.7*((f/8)^0.5)*(((Pr)^(2/3))-1)));
h = Nu*K/b;
U = ((1/h)+(1/hc))^(-1);
((Tbo-Tai)/(Tw-Tai)) = 1-(exp((-4*U*l)/(rho*u*Cp*b)));
delTb = Tbo-Tai;
end Ex7_6;
//======================================================
