//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 8: Natural Convection in Single Phase Fluids and during Film Condensation
//Example: 8.1 Page 414
//Title: A Thin Walled Metal Tank
//======================================================
model Ex8_1

//==========
//Parameter Section

parameter Real nu(unit = "m^2/s") = 1.578e-5 "Kinematic Viscosity of Air at Mean Film Temperature";
parameter Real alpha(unit = "m^2/s") = 2.213e-5 "Thermal Diffusivity of Air at Mean Film Temperature";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to Gravity on the Earth's Surface";
parameter Real K(unit = "W/(m K)") = 0.02623 "Thermal Conductivity of Air at Mean Film Temperature";
parameter Real Pr = 0.713 "Prandtl Number of Air at Mean Film Temperature";

//==========
//Variable Section

input Real Tf(unit = "deg C",start = 40) "Temperature of the Fluid";
input Real Ta(unit = "deg C",start = 14) "Temperature of Air";
input Real l(unit = "m",start = 0.4) "Height of the Sides of the Tank";
output Real havg(unit = "W/(m^2 K)") "Average Convective Heat Transfer Coefficient";
output Real qavg(unit = "W/m^2") "Average Heat Flux";
Real beta(unit = "1/K") "Coefficient of Volume Expansion";
Real Ra "Rayleigh's Number";
Real Nu "Nusselt's Number";
Real delta(unit = "m") "Boundary Layer Thickness";
Real Tmf(unit = "deg C") "Mean Film Temperature";

//==========
//Equation Section

equation
Tmf = (Tf+Ta)/2;
beta = 1/(Ta+273);
Ra = (g*beta*(Tf-Ta)*(l^3))/(nu*alpha);
Nu = 0.678*(Ra^0.25)*((Pr/(0.952+Pr))^0.25);
//Refer Equation 8.26 Page 414
havg = Nu*K/l;
qavg = havg*(Tf-Ta);
delta = 3.936*(((0.952+Pr)/(Pr^2))^0.25)*((Ra/Pr)^(-0.25))*l;
//delta = 0.01723 m. delta is too small when compared to the Height of the Sides of the Tank. Therefore Boundary Layer Concept is Valid.
end Ex8_1;
//======================================================
