//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 9: Heat Transfer in Boiling and Other Phase Change Configurations
//Example: 9.1 Page 471
//Title: Approximate Size of Active Nucleation Sites in Water
//======================================================
model Ex9_1

//==========
//Parameter Section

parameter Real atmp(unit = "N/m^2") = 1.01325e5 "Atmospheric Pressure";
parameter Real psat1(unit = "N/m^2") = 1.203e5 "Saturated Vapour Pressure at 108 deg C";
parameter Real psat2(unit = "N/m^2") = 1.769e5 "Saturated Vapour Pressure at 116 deg C";
parameter Real sigma1(unit = "N/m") = 57.36e-3 "Surface Tension of Water at 108 deg C";
parameter Real sigma2(unit = "N/m") = 55.78e-3 "Surface Tension of Water at 116 deg C";

//==========
//Variable Section

output Real Rb1(unit = "m") "Radius of the Active Nucleation Sites in water at 108 deg C";
output Real Rb2(unit = "m") "Radius of the Active Nucleation Sites in water at 116 deg C";

//==========
//Equation Section

equation
Rb1 = (2*sigma1)/(psat1-atmp);         //Refer Page 468
Rb2 = (2*sigma2)/(psat2-atmp);         //Refer Page 468
//Therefore the Radius of the Active Nucleation Sites lie in between Rb2 and Rb1
end Ex9_1;
//======================================================
