//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 9: Heat Transfer in Boiling and Other Phase Change Configurations
//Example: 9.2 Page 474
//Title: Surface Correction Factor of Heater
//======================================================
model Ex9_2

//==========
//Parameter Section

parameter Real Tsat(unit = "deg C") = 100 "Saturation Temperature of Water";
parameter Real Cp(unit = "kJ/(kg K)") = 4.22 "Specific Heat Capacity of Water";
parameter Real Pr = 1.75 "Prandtl Number of Water at 100 deg C";
parameter Real sigma(unit = "N/m") = 0.0589 "Surface Tension of Water at 100 deg C";
parameter Real hfg(unit = "kJ/kg") = 2257 "Latent Heat of Vapourization of Water";
parameter Real mu(unit = "kg/(m s)") = 0.000282 "Dynamic Viscosity of Water at 100 deg C";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to Gravity";

//==========
//Variable Section

input Real delrho(unit = "kg/m^3",start = 958) "Difference in Densities";
output Real Csf "Surface Correction Factor";
Real q(unit = "kW/m^2") "Heat Flux";
Real delT(unit = "K") "Temperature Difference";

//==========
//Equation Section

equation
q = 800;          //Refer Fig. 9.2 Page 464
delT = 22;        //Refer Fig. 9.2 Page 464
Csf = (((delT^3)*mu*(Cp^3)/(q*(hfg^2)*(Pr^3)))*(((g*delrho)/sigma)^0.5))^(1/3);
end Ex9_2;
//======================================================
