//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 9: Heat Transfer in Boiling and Other Phase Change Configurations
//Example: 9.8 Page 492
//Title: Minimum Heat Flux
//======================================================
model Ex9_8

//==========
//Parameter Section

parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to Gravity";
parameter Real sigma(unit = "N/m") = 0.0589 "Surface Tension of Water";
parameter Real hfg(unit = "J/kg") = 2257e3 "Latent Heat of Vapourization of Water";
parameter Real rhof(unit = "kg/m^3") = 958 "Density of Water";
parameter Real rhog(unit = "kg/m^3") = 0.597 "Density of Gas";

//==========
//Variable Section

output Real qmin(unit = "W/m^2") "Minimum Heat Flux";

//==========
//Equation Section

equation
qmin = 0.09*rhog*hfg*(((g*(rhof-rhog)*sigma)/((rhof+rhog)^2))^0.25);
//Refer Equation 9.34 Page 492
//The Property Values are taken from Example 9.5 Page 484
end Ex9_8;
//======================================================
