//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 9: Heat Transfer in Boiling and Other Phase Change Configurations
//Example: 9.9 Page 505
//Title: Temperature of the Wall
//======================================================
model Ex9_9

//==========
//Parameter Section

parameter Real mu(unit = "kg/(m s)") = 1.297e-4 "Dynamic Viscosity of Water at 207 deg C";
parameter Real K(unit = "W/(m K)") = 0.6590 "Thermal Conductivity of Water at 207 deg C";
parameter Real rhof(unit = "kg/m^3") = 856.5 "Density of Water at 207 deg C";
parameter Real rhog(unit = "kg/m^3") = 9.014 "Density of Gas at 207 deg C";
parameter Real hfg(unit = "J/kg") = 1913e3 "Latent Heat of Vapourization of Water at 207 deg C";
parameter Real Pr = 0.892 "Prandtl Number of Water at 207 deg C";

//==========
//Variable Section

input Real m(unit = "kg/s",start = 0.6) "Mass Flow Rate of Water";
input Real Tb(unit = "deg C",start = 207) "Temperature of Water";
input Real d(unit = "m",start = 5e-2) "Diameter of the Vertical Tube";
input Real q(unit = "W/m^2",start = 184e3) "Rate of Heating of the Vertical Tube";
input Real x(start = 0.2) "Quality";
output Real Tw(unit = "deg C") "Wall Temperature";
Real G(unit = "kg/(m^2 s)") "Mass Velocity";
Real hlo(unit = "W/(m^2 K)") "Liquid-Only Heat Transfer Coefficient";
Real hb1(unit = "W/(m^2 K)") "Boiling Heat Transfer Coefficient";
Real hb2(unit = "W/(m^2 K)") "Boiling Heat Transfer Coefficient";
Real A(unit = "m^2") "Area of the Vertical Tube";
Real Re "Reynolds Number";
Real f "Correction Factor";
Real Nu "Nusselt's Number";
Real Co "Convection Number";
Real Bo "Boiling Number";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);
A = pi*d*d/4;
G = m/A;
Re = G*d/mu;
f = ((1.82*log10(Re)-1.64)^(-2));
Nu = ((f/8)*(Re-1000)*Pr)/(1+(12.7*((f/8)^0.5)*((Pr^(2/3))-1)));
hlo = K*Nu/d;
Co = (((1-x)/x)^0.8)*((rhog/rhof)^0.5);
Bo = q/(G*hfg);
hb1 = hlo*((1-x)^0.8)*(0.6683*(Co^(-0.2))+(1058*(Bo^0.7)));
hb2 = hlo*((1-x)^0.8)*(1.136*(Co^(-0.9))+(667.2*(Bo^0.7)));
Tw = Tb+(q/hb2);
end Ex9_9;
//======================================================
