//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 1: Introduction
//Example: 1.2 Page 16
//Title: Temperature Distribution and Heat Conduction
//======================================================
model Ex1_2

//==========
//Parameter Section

parameter Real Kcu(unit = "W/(m K)") = 372 "Thermal Conductivity of the Copper Slab";
parameter Real Kss(unit = "W/(m K)") = 17 "Thermal Conductivity of the Stainless Steel Layer";

//==========
//Variable Section

input Real lcu(unit = "mm",start = 3) "Thickness of the Copper Slab";
input Real lss(unit = "mm",start = 2) "Thickness of the Stainless Steel Layers";
input Real T1(unit = "deg C",start = 400) "Temperature on one side of the Composite Wall";
input Real T2(unit = "deg C",start = 100) "Temperature on the other side of the Composite Wall";
Real delTcu(unit = "K") "Temperature Difference across the Copper Slab";
Real delTss(unit = "K") "Temperature Difference across the Stainless Steel Layer";
output Real q(unit = "kW/m^2") "Heat Flux through the Layers";

//==========
//Equation Section

equation
(T1-T2) = delTcu*(1+2*((Kcu/lcu)/(Kss/lss)));  //Equation for Temperature Distribution across the Layers //Refer Page 16
delTss = ((T1-T2)-delTcu)/2;      //Refer Page 16
q = Kss*(delTss/(lss*(1e-3)))*(1e-3);     //Equation for Heat Flux through the Layers //Refer Page 16
end Ex1_2;
//======================================================
