//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 1: Introduction
//Example: 1.4 Page 25
//Title: Response Time of a Thermocouple
//Remark: In the Simulation Setup Window change the Stop Time from 1 to 5 to generate the full graph.
//======================================================
model Ex1_4

//==========
//Parameter Section

parameter Real h(unit = "W/(m^2 K)") = 250 "Heat Transfer Coefficient";
parameter Real K(unit = "W/(m K)") = 45 "Thermal Conductivity of the Solder";
parameter Real rho(unit = "kg/m^3") = 9300 "Density of the solder";
parameter Real c(unit = "kJ/(kg K)") = 0.18 "Specific Heat Capacity of the Solder";

//==========
//Variable Section

input Real Tg(unit = "deg C",start = 200) "Temperature of the Gas Flow";
input Real Ta(unit = "deg C",start = 20) "Ambient Temperature";
input Real D(unit = "m",start = 1e-3) "Diameter of the Solder";
output Real Tc(unit= "s") "Time Constant of the Thermocouple";
output Real Bi "Biot Number";
Real T(unit = "deg C") "Temperature of the Thermocouple";

//==========
//Equation Section

equation
Tc = (rho*c*1000*D)/(6*h);      //1 kJ = 1000 J 
T = Tg-((Tg-Ta)*exp(-time/Tc)); //Refer Page 22
//From the Graph (T vs Time) generated, it is observed that the thermocouple reaches 95% of the signal in approximately three time constants. Therefore, the system i.e., the Thermocouple can assumed to be a Lumped Heat Capacity System.
Bi = (h*D/2)/K;     //Biot Number Calcultaion
//The Assumption taken is valid since Bi<<1
end Ex1_4;
//======================================================
