//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 10: Radiative Heat Transfer
//Example: 10.10 Page 565
//Title: Rate of Heat Transfer
//======================================================
model Ex10_10

//==========
//Parameter Section

parameter Real sigma(unit = "W/(m^2 K^4)") = 5.67e-8 "Stefan Boltzmann Constant";

//==========
//Variable Section

input Real T1(unit = "K",start = 773) "Temperature of the First Stainless Steel Side";
input Real T2(unit = "K",start = 773) "Temperature of the Second Stainless Steel Side";
input Real T3(unit = "K",start = 373) "Temperature of the Copper Side";
input Real ess(start = 0.5) "Emissivity of Stainless Steel Sides";
input Real ec(start = 0.15) "Emissivity of Copper Side";
output Real Qnet(unit = "W/m") "Rate of Heat Transfer to the Copper Base";
Real B1(unit = "W/m^2") "Heat Flux at Node 1";
Real A(unit = "m^2") "Area of the Duct";

//==========
//Equation Section

equation
B1 = sigma*(0.232*(T3^4)+0.319*(T2^4)+0.447*(T1^4));
A = 0.5;      //Refer Figure 10.18 Page 566
Qnet = A*(ec/(1-ec))*sigma*((T3^4)-0.232*(T3^4)-0.319*(T2^4)-0.447*(T1^4));
end Ex10_10;
//======================================================
