//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 10: Radiative Heat Transfer
//Example: 10.12 Page 582
//Title: Temperature of Roof
//======================================================
model Ex10_12

//==========
//Parameter Section

parameter Real sigma(unit = "W/(m^2 K^4)") = 5.67e-8 "Stefan Boltzmann Constant";


//==========
//Variable Section

input Real qs(unit = "W/m^2",start = 600) "Heat Radiated by the Sun on the Roof";
input Real havg(unit = "W/(m^2 K)",start = 8) "Average Heat Transfer Coefficient";
input Real Tair(unit = "K",start = 308) "Temperature of Air";
input Real Ts(unit = "K",start = 291) "Temperature of Sky";
input Real e(start = 0.9) "Emissivity";
output Real Trw(unit = "K") "Temperature of the Roof coated with White Acrylic Paint";
output Real Trb(unit = "K") "Temperature of the Roof coated with Black Paint";
Real a "Absorptivity";

//==========
//Equation Section

equation
((havg*(Trb-Tair))+(e*sigma*((Trb^4)-(Ts^4)))) = e*qs;
a = 0.26;     //Refer Table 10.4 Page 582
((havg*(Trw-Tair))+(e*sigma*((Trw^4)-(Ts^4)))) = a*qs;
end Ex10_12;
//======================================================
