//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 11: An Introduction to Mass Transfer
//Example: 11.11 Page 650
//Title: Concentration of Helium
//======================================================
model Ex11_11

//==========
//Parameter Section

parameter Real muair(unit = "kg/(m s)") = 1.857e-5 "Dynamic Viscosity of Air at 300 K";
parameter Real rhoair(unit = "kg/m^3") = 1.177 "Density of Air at 300 K";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to Gravity at the Earth's Surface";

//==========
//Variable Section

input Real h(unit = "m",start = 0.4) "Height of the Vertical Wall";
input Real mHes(unit = "kg/(m^2 s)",start = 87e-6) "Mass Flux of Helium into the Surroundings";
input Real Tair(unit = "K",start = 300) "Temperature of Air";
input Real THe(unit = "K",start = 300) "Temperature of Helium";
input Real P(unit = "atm",start = 1) "Atmospheric Pressure";
output Real mHea "Average Concentration of Helium at the Wall";
Real DHeair(unit = "m^2/s") "Diffusion Coefficient for Diffusion of Helium into Air";
Real rhof(unit = "kg/m^3") "Film Density at the Mean Film Composition";
Real rhos(unit = "kg/m^3") "Wall Density at the Mean Film Composition";
Real mHe "Assumed Concentration of Helium";
Real Ra "Rayleigh's Number";
Real Nu "Nusselt's Number";
Real Sc "Schmidt Number";

//==========
//Equation Section

equation
mHe = 0.010;
rhof = 1.141;
rhos = 1.107;
DHeair = 7.119e-5;
Sc = (muair/rhof)/DHeair;
Ra = (g*(rhoair-rhos)*mHes*(h^4))/(muair*rhof*(DHeair^2)*mHe);
Nu = (6/5)*(((Ra*Sc)/(4+(9*(Sc^0.5))+(10*Sc)))^0.2);
mHea = (mHes*h)/(rhof*DHeair*Nu);
//For the Second Iteration substitute the Value obtained for mHea as mHe.
end Ex11_11;
//======================================================
