//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 11: An Introduction to Mass Transfer
//Example: 11.14 Page 657
//Title: Concentration Distribution of Water Vapour

//Remarks
//1. Create a Paramteric Plot by Clicking on the "New Parametric Plot Window" Icon in the "Plotting" Tab.
//2. In the "Simulation Setup" window change the "Stop Time" from 1 to 0.2.
//3. Click y(Length across the Tube in m) checkbox first and then Click x(Mole Fraction of Water Vapour) checkbox to Plot a graph between Mole Fraction of Water Vapour and Length across the Tube(m).
//======================================================
model Ex11_14

//==========
//Parameter Section

parameter Real R(unit = "kJ/(kmol K)") = 8.314 "Universal Gas Constant";
parameter Real Mw(unit = "kg/kgmol") = 18 "Molecular Weight of Water";

//==========
//Variable Section

input Real T(unit = "K",start = 325) "Temperature of the System";
input Real l(unit = "m",start = 0.2) "Length of the Tube";
input Real P(unit = "Pa",start = 101325) "Pressure of the System";
input Real xw1(start = 0.01) "Mole Fraction of Water Vapour at the Top of the Tube";
Real xw2 "Mole Fraction of Water Vapour";
Real pv(unit = "Pa") "Vapour Pressure of Water Vapour";
Real C(unit = "kmol/m^3") "Molar Concentration in the Tube";
Real N(unit = "kmol/(m^2 s)") "Molar Evaporation Rate";
Real n(unit = "kg/(m^2 s)") "Mass Evaporation Rate";
Real D(unit = "m^2/s") "Diffusion Coefficient";
Real x "Mole Fraction of Water Vapour";
Real y(unit = "m",max = 0.2) "Length along the Tube";

//==========
//Equation Section

equation
pv = 1.341e4;      //From Steam Tables
xw2  = pv/P;
C*1000 = P/(R*T);
N = (D*C/l)*(log(1+((xw1-xw2)/(xw2-1))));
n = N*Mw;
D = 1.067e-4;
x = (N/n)+((xw2-(N/n))*exp((N*y)/(D*C)));
y = time;
end Ex11_14;
//======================================================
