//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 11: An Introduction to Mass Transfer
//Example: 11.3 Page 621
//Title: Diffusion Coefficient for Diffusion of Hydrogen in Air

//Remarks
//1. A denotes Hydrogen and B denotes Air
//2. eA/KA is represented by eAKA, eB/KB is represented by eBKB and eAB/KAB is represented by eABKAB
//======================================================
model Ex11_3

//==========
//Parameter Section

parameter Real sigmaA(unit = "m") = 3.711e-10 "Molecular Diameter of Hydrogen";
parameter Real sigmaB(unit = "m") = 2.827e-10 "Molecular Diameter of Air";
parameter Real eAKA(unit = "K") = 78.6 "Reduced Temperature of Hydrogen";
parameter Real eBKB(unit = "K") = 59.7 "Reduced Temperature of Air";
parameter Real MH2(unit = "kg/kmol") = 2.016 "Molecular Weight of Hydrogen";
parameter Real Mair(unit = "kg/kmol") = 28.97 "Molecular Weight of Air";

//==========
//Variable Section

input Real T(unit = "K",start = 276) "Temperature of Air";
input Real P(unit = "atm",start = 1) "Pressure of Air";
output Real DAB(unit = "m^2/s") "Diffusion Coefficient of Hydrogen in Air";
Real sigmaAB(unit = "m") "Average Diameter";
Real eABKAB(unit = "K") "Reduced Temperature";
Real ohm "Temperature Dependent Collision Integral";
Real k "Constant";

//==========
//Equation Section

equation
sigmaAB = (sigmaA+sigmaB)/2;
eABKAB = (eAKA*eBKB)^0.5;
k = T/eABKAB;
ohm = 0.8822;         //Refer Table 11.3 Page 622
DAB = (((1.8583e-7*(T^1.5))/(P*((sigmaAB*1e10)^2)*ohm))*(((1/Mair)+(1/MH2))^0.5));
end Ex11_3;
//======================================================
