//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 11: An Introduction to Mass Transfer
//Example: 11.5 Page 636
//Title: Mass Fraction of Water Vapour

//Remarks
//1. Create a Paramteric Plot by Clicking on the "New Parametric Plot Window" Icon in the "Plotting" Tab.
//2. In the "Simulation Setup" window change the "Stop Time" from 1 to 100.
//3. Click T(Temperature in deg C) checkbox first and then Click mw(Mass Fraction of Water Vapour) checkbox to Plot a graph between Mass Fraction of Water Vapour and Temperature(in deg C).
//======================================================
model Ex11_5

//==========
//Parameter Section

parameter Real Patm(unit = "mm Hg") = 760 "Atmospheric Pressure";
parameter Real Mw(unit = "kg/kgmol") = 18.02 "Molecular Weight of Water Vapour";
parameter Real Mair(unit = "kg/kgmol") = 28.96 "Molecular Weight of Air";

//==========
//Variable Section

Real T(unit = "deg C",min = 0, max = 100) "Temperature of Tea";
Real mw "Mass Fraction of Water Vapour";

//==========
//Equation Section

equation
mw = (Mw*((10^(8.07131-(1730.63/(T+233.426))))/Patm))/((((10^(8.07131-(1730.63/(T+233.426))))/Patm)*Mw)+((1-((10^(8.07131-(1730.63/(T+233.426))))/Patm))*Mair));
T = time;
//At T = 100 deg C, the saturated Vapour Pressure of Water Vapour is found to be approximately 1 atm or 101.32 kPa. Therefore the Mass Fraction of Water Vapour at T = 100 deg C is approximately, mw = 1.00. From the Graph plotted, it is noted that the Mass Fraction of Water Vapour attains 10% of its final value (mw = 1) at 54.6 deg C.
end Ex11_5;
//======================================================
