//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 2: Heat Conduction Concepts, Thermal Resistance, and the Overall Heat Transfer Coefficient
//Example: 2.10 Page 81
//Title: Overall Heat Transfer Coefficient
//======================================================
model Ex2_10

//==========
//Variable Section

Real havg(unit = "W/(m^2 K)") "Average Heat Transfer Coefficient due to Convection";
Real hc(unit = "W/(m^2 K)") "Average Heat Transfer Coefficient due to Conduction";
Real hb(unit = "W/(m^2 K)") "Average Heat Transfer Coefficient due to Boiling";
output Real U(unit = "W/(m^2 K)") "Overall Heat Transfer Coefficient";

//==========
//Equation Section

equation
havg = 200;     //Refer Page 81
hc = 160000;    //Refer Page 81
hb = 5000;      //Refer Page 81
U = 1/((1/havg)+(1/hc)+(1/hb));
end Ex2_10;
//======================================================
