//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 2: Heat Conduction Concepts, Thermal Resistance, and the Overall Heat Transfer Coefficient
//Example: 2.13 Page 87
//Title: Heat Exchanger Installation
//======================================================
model Ex2_13

//==========
//Variable Section

input Real U(unit = "W/(m^2 K)",start = 4000) "Overall Heat Transfer Coefficient of the Water-Cooled Steam Condenser";
output Real Uc1(unit = "W/(m^2 K)") "Corrected Overall Heat Transfer Coefficient of the Condenser";
output Real Uc2(unit = "W/(m^2 K)") "Corrected Overall Heat Transfer Coefficient of the Condenser";

//==========
//Equation Section

equation
1/Uc1 = (1/U)+0.0006;     //Refer Table 2.3 Page 86
1/Uc2 = (1/U)+0.0020;     //Refer Table 2.3 Page 86
//The Overall Heat Transfer Coefficient of the Condenser is reduced from U = 4000 W/(m^2 K) to between Uc2 and Uc1. U is reduced from 4000 W/(m^2 K) to between 444 W/(m^2 K) to 1176 w/(m^2 K). Therefore the Engineer who installed the Heat Exchanger was wrong with an Error Percentage of 70% to 90%.
end Ex2_13;
//======================================================
