//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 2: Heat Conduction Concepts, Thermal Resistance, and the Overall Heat Transfer Coefficient
//Example: 2.3 Page 66
//Title: Steady Flux of Water Vapour
//======================================================
model Ex2_3

//==========
//Parameter Section

parameter Real D12(unit= "m^2/s") = 2.84e-5 "Binary Diffusion Coefficient of Water Vapour";
parameter Real rho(unit = "kg/m^3") = 1.18 "Density of Water Vapour";

//==========
//Variable Section

input Real mw(start = 0.01) "Mass Fraction of Water Vapour in one end";
input Real l(unit = "m",start = 1) "Length of the Thin Tube";
output Real fw(unit = "kg/(m^2 s)") "Steady Flux of Water Vapour";

//==========
//Equation Section

equation
fw = rho*D12*mw/l;      //Refer Page 66
end Ex2_3;
//======================================================
