//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 2: Heat Conduction Concepts, Thermal Resistance, and the Overall Heat Transfer Coefficient
//Example: 2.7 Page 74
//Title: Temperature of Resistor
//======================================================
model Ex2_7

//==========
//Parameter Section

parameter Real sigma(unit = "W/(m^2 K^4)") = 5.67e-8 "Stefan-Boltzmann Constant";

//==========
//Variable Section

input Real Q(unit = "W",start = 0.1) "Heat Dissipated by the Electrical Heater";
input Real d(unit = "m",start = 3.6e-3) "Outer Diameter of the Cylindrical Resistor";
input Real l(unit = "m",start = 10e-3) "Length of the Cylindrical Resistor";
input Real Tair(unit = "deg C",start = 35) "Temperature of the Air in the Cylindrical Cabinet";
input Real havg(unit = "W/(m^2 K)",start = 13) "Average Convective Heat Transfer Coefficient";
input Real e(start = 0.9) "Emissivity of the Electrical Resistor";
output Real Tr1(unit = "deg C") "Guessed Temperature of the Electrical Resistor";
output Real Tr(unit = "deg C") "Original Temperature of the Electrical Resistor";
Real Tm(unit = "deg C") "Mean Film Temperature";
Real hrad(unit = "W/(m^2 K)") "Heat Transfer Coefficient due to Radiation";
Real Req(unit = "K/W") "Equivalent Thermal Resistance";
Real A(unit = "m^2") "Area of Heat Transfer";
Real k "Constant";                     //Constant
Real pi "Constant";                    //Constant

//==========
//Equation Section

equation
pi=2*Modelica.Math.asin(1.0);         //Constant pi
//Assuming the Temperature of the Resistor to be equal to 50 deg C, the following calculations are carried out.
Tm = (Tair+50)/2;
hrad = 4*sigma*e*((Tm+273)^3);
A = pi*d*l;
1/Req = A*(hrad+havg);
Tr1 = Tair+(Q*Req);     //Guessed Temperature of the Resistor
//For the next Iteration, instead of substituting the Temperature of Resistor to be equal to 50 deg C, the Temperature of the Resistor has to be substituted the value of Tr1. Repeating the same set of calculations yields, hrad = 7.38 W/(m^2 K) and Req = 434.2276 K/W. Now, the correct Temperature of the Resistor can be found out using the above mentioned values of hrad and Req.
Tr = Tair+(Q*434.2276);
k = 0.25*(((Tr-Tair)/(((Tr+Tair)/2)+273))^2);
//Since the value of k is very much less than 1, the approximation made to find hrad is valid.
end Ex2_7;
//======================================================
//Remark
//Area of Heat Transfer,A calculated in the textbook solution is incorrect. Area of Heat Transfer,A is given as 1.33E-4 whereas it should be 1.13E-4.
//The Original Temperature of the Resistor is, Tresis = 78.4228 deg C. But in the Textbook it is give to be  Tresis = 72.3 deg C.
