//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 3: Heat Exchanger Design
//Example: 3.4 Page 122
//Title: Area of Shell and Tube Heat Exchanger
//======================================================
model Ex3_4

//==========
//Parameter Section

parameter Real cpoil(unit = "J/(kg K)") = 2282 "Specific Heat Capacity of Oil";
parameter Real U(unit = "W/(m^2 K)") = 416 "Overall Heat Transfer Coefficient";

//==========
//Variable Section

input Real moil(unit = "kg/s",start = 5.795) "Mass Flow Rate of Oil through the Shell Side of the Heat Exchanger";
input Real Toe(unit = "deg C",start = 181) "Temperature at which Oil Enters the Heat Exchanger";
input Real Tol(unit = "deg C",start = 38) "Temperature at which Oil Leaves the Heat Exchanger";
input Real Twe(unit = "deg C",start = 32) "Temperature at which Water Enters the Heat Exchanger";
input Real Twl(unit = "deg C",start = 49) "Temperature at which Water Leaves the Heat Exchanger";
output Real A(unit = "m^2") "Area of the Heat Exhanger";
Real LMTD(unit = "K") "Log Mean Temperature Difference";
Real Q(unit = "W") "Rate of Heat Transfer in the Heat Exchanger";
Real R "Constant";
Real P "Constant";
Real F "Correction Factor";

//==========
//Equation Section

equation
LMTD = ((Toe-Twl)-(Tol-Twe))/log((Toe-Twl)/(Tol-Twe));
R = (Toe-Tol)/(Twl-Twe);
P = (Twl-Twe)/(Toe-Twe);
//From the Graph in Page 120 (Figure 3.14(b)), the Value of F (Correction Factor) can be found using the values of R and P. Since R > 1, the value of F is found using the values of R = 1/R and P = R*P.
//It is seen fom the Graph(Figure 3.14(b)) that the lines R and P do not intersect with each other. Therefore the value of F is found from Figure 3.14(a). The value of F is found to be 0.92
F = 0.92;
Q = moil*cpoil*(Toe-Tol);
Q = U*A*F*LMTD;
end Ex3_4;
//======================================================
