//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 3: Heat Exchanger Design
//Example: 3.6 Page 127
//Title: Area and Effectiveness of Heat Exchanger
//======================================================
model Ex3_6

//==========
//Parameter Section

parameter Real U(unit = "W/(m^2 K)") = 500 "Overall Heat Transfer Coefficient of the Heat Exchanger";

//==========
//Variable Section

input Real Tce(unit = "deg C",start = 40) "Temperature at which the Cold Flow Enters";
input Real The(unit = "deg C",start = 150) "Temperature at which Hot Flow Enters";
input Real Cc(unit = "W/K",start = 20e3) "Specific Heat of Cold Flow";
input Real Ch(unit = "W/K",start = 10e3) "Specific Heat of Hot Flow";
input Real Thl(unit = "deg C",start = 90) "Temperature at which Hot Flow Exits or Leaves";
output Real Tcl(unit = "deg C") "Temperature at which Cold Flow Exits or Leaves";
output Real A(unit = "m^2") "Area of the Heat Exchanger";
Real Q(unit = "W") "Rate of Heat Transfer in the Heat Exchanger";
Real LMTD(unit = "K") "Log Mean Temperature Difference";
Real K "Cmin/Cmax";

//==========
//Equation Section

equation
K = Ch/Cc;                      //K = Cmin/Cmax
Tcl = Tce+((Ch/Cc)*(The-Thl));  //Refer Page 127
LMTD = ((The-Tce)-(Thl-Tcl))/log((The-Tce)/(Thl-Tcl));
Q = Ch*(The-Thl);
A = Q/(U*LMTD);
//Area of the Heat Exchanger can also be found by using the values of e and NTU, from the relation A = Ch*NTU/U. The Answer obtained by this method differs from that obtained by following the above steps only by 1%. The Area of Heat Exchanger is found to be, A = 23.00 m^2 by using the relation A = Ch*NTU/U.
end Ex3_6;
//======================================================
