//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 4: Analysis of Heat Conduction and Some Steady One-Dimensional Problems
//Example: 4.8 Page 174
//Title: Fin Design
//======================================================
model Ex4_8

//==========
//Parameter Section

parameter Real K(unit = "W/(m K)") = 205 "Thermal Conductivity of Aluminum";
parameter Real h(unit = "W/(m^2 K)") = 120 "Average Convective Heat Transfer Coefficient between the Rod and Air";

//==========
//Variable Section

input Real d(unit = "m",start = 2e-2) "Diameter of the Aluminum Rod";
input Real l(unit = "m",start = 8e-2) "Length of the Aluminum Rod";
input Real Twall(unit = "deg C",start = 150) "Temperature of the Surface of the Wall";
input Real Tair(unit = "deg C",start = 26) "Temperature of Air";
output Real Ttip1(unit = "deg C") "Temperature of the Tip of the Aluminum Rod considering Heat Transfer from the tip";
output Real Ttip2(unit = "deg C") "Temperature of the Tip of the Aluminum Rod without considering Heat Transfer from the tip";
Real ml "Constant";
Real Biax "Biot Number in the Axial or Transverse Direction";
Real Thetatip1 "Constant of Temperature";
Real Thetatip2 "Constant of Temperature";
Real P(unit = "m") "Perimeter of the Tip of the Rod";
Real A(unit = "m^2") "Area of the Tip of the Rod";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);
P = pi*d;
A = pi*(d^2)/4;
ml = ((h*P*(l^2))/(K*A))^(1/2);
Biax = h*l/K;
//Calculation of Temperature of the Tip of the Rod Considering Heat Transfer from the Tip
Thetatip1 = (cosh(0)+((Biax/ml)*sinh(0)))/(cosh(ml)+((Biax/ml)*sinh(ml)));
Ttip1 = Tair+Thetatip1*(Twall-Tair);
//Calculation of Temperature of the Tip of the Rod Without considering Heat Transfer from the Tip
Thetatip2 = 1/cosh(ml);
Ttip2 = Tair+Thetatip2*(Twall-Tair);
//Comparing the Temperatures of the Tip calculated with and without considering Heat Transfer from the Tip of the Rod, it is observed that the two Temperatures does not differ much. The two Temperatures differ approximately by 2%.
end Ex4_8;
//======================================================
