//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 4: Analysis of Heat Conduction and Some Steady One-Dimensional Problems
//Example: 4.9 Page 176
//Title: Temperature of the Root neglecting Convection from the Tip
//======================================================
model Ex4_9

//==========
//Parameter Section

parameter Real K(unit = "W/(m K)") = 205 "Thermal Conductivity of Aluminum";
parameter Real h(unit = "W/(m^2 K)") = 120 "Average Convective Heat Transfer Coefficient between the Rod and Air";

//==========
//Variable Section

input Real d(unit = "m",start = 2e-2) "Diameter of the Aluminum Rod";
input Real l(unit = "m",start = 8e-2) "Length of the Aluminum Rod";
input Real Twall(unit = "deg C",start = 150) "Temperature of the Surface of the Wall";
input Real Tair(unit = "deg C",start = 26) "Temperature of Air";
output Real Troot(unit = "deg C") "Actual Temperature of the Root of the Aluminum Rod";
output Real Qerror(unit = "%") "Percentage Error in the Rate of Heat Transfer(Q)";
Real ml "Constant";
Real A "h*r/K";
Real B "m*r*tanh(ml)";

//==========
//Equation Section

equation
//From the Previous Problem, Example 4.8, the value of ml is taken
ml = 0.8656;
A = h*(d/2)/K;
B = ml*((d/2)/l)*tanh(ml);
//Using the values of A (i.e,.) h*r/k and B (i.e,.) m*r*tanh(ml), the value of 1-(Qactual/Qno temperature depression) is found out from the Graph (Lower Part of Figure 4.10(b)) in Page 177. 1-(Qactual/Qno temperature depression) is found out to be approximately 0.05
Qerror = 0.05*100;
Troot = Twall-(Twall-Tair)*(Qerror/100);
end Ex4_9;
//======================================================
