//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 5: Transient and Multidimensional Heat Conduction
//Example: 5.12 Page 252
//Title: Temperature of Square Iron Rod
//======================================================
model Ex5_12

//==========
//Parameter Section

parameter Real h(unit = "W/(m^2 K)") = 800 "Average Heat Transfer Coefficient of the Square Iron Rod";
parameter Real K(unit = "W/(m K)") = 76 "Thermal Conductivity of Iron";
parameter Real alpha(unit = "m^2/s") = 0.0000226 "Thermal Diffusivity of Iron";

//==========
//Variable Section

input Real l(unit = "m",start = 4e-2) "Thickness of the Square Iron Rod";
input Real Ti(unit = "deg C",start = 100) "Temperature at one end of the Square Iron Rod";
input Real Tc(unit = "deg C",start = 20) "Temperature of the Coolant";
input Real t(unit = "s",start = 10) "Time after which the Temperature of the Iron Rod is measured";
output Real T(unit = "deg C") "Temperature at the Points of Interest";
Real Bi "Biot Number";
Real Fo "Fourier Number";
Real r1 "r1 = (x/L)1";
Real r2 "r2 = (x/L)2";
Real theta1 "Constant of Temperature";
Real theta2 "Constant of Temperature";
Real theta "Constant of Temperature";

//==========
//Equation Section

equation
Bi = (h*(l/2))/K;     //Bi1 = Bi2 = Bi
r1 = 0;
r2 = 1/2;
Fo = (alpha*t)/((l/2)^2); //Fo1 = Fo2 = Fo
theta1 = 0.93;  //From the Upper Left-Hand Side of Figure 5.7 (Page 221), and using the Values of (x/L)1 = 0, 1/Bi = 4.75, and Fo = 0.565 the Value of theta1 is obtained to be, theta1 = 0.93 
theta2 = 0.91;  //From both the Upper Right-Hand Side and the Lower Left-Hand Side of Figure 5.7 (Page 221), and using the Values of (x/L)2 = 0.5, 1/Bi = 4.75, and Fo = 0.565 the Value of theta2 is obtained to be, theta2 = 0.91
theta = theta1*theta2;
(T-Tc)/(Ti-Tc) = theta;
end Ex5_12;
//======================================================
