//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 5: Transient and Multidimensional Heat Conduction
//Example: 5.13 Page 253
//Title: Mean Temperature of Square Iron Rod
//======================================================
model Ex5_13

//==========
//Parameter Section

parameter Real h(unit = "W/(m^2 K)") = 800 "Average Heat Transfer Coefficient of the Square Iron Rod";
parameter Real K(unit = "W/(m K)") = 76 "Thermal Conductivity of Iron";
parameter Real alpha(unit = "m^2/s") = 0.0000226 "Thermal Diffusivity of Iron";

//==========
//Variable Section

input Real l(unit = "m",start = 4e-2) "Thickness of the Square Iron Rod";
input Real Ti(unit = "deg C",start = 100) "Temperature at one end of the Square Iron Rod";
input Real Tc(unit = "deg C",start = 20) "Temperature of the Coolant";
input Real t(unit = "s",start = 10) "Time after which the Temperature of the Square Iron Rod is measured";
output Real T(unit = "deg C") "Mean Temperature of the Square Iron Rod after 10 s";
Real Bi "Biot Number";
Real Fo "Fourier Number";
Real phi1 "Constant of Temperature";
Real phi2 "Constant of Temperature";
Real phi "Constant of Temperature";

//==========
//Equation Section

equation
Bi = (h*(l/2))/K;     //Bi1 = Bi2 = Bi
Fo = (alpha*t)/((l/2)^2); //Fo1 = Fo2 = Fo
phi1 = 0.10;  //From the Figure 5.10a (Page 215) and for the Values of Bi = 0.2105 and Fo = 0.565, it is found that phi1 = 0.1
phi2 = 0.10;  //From the Figure 5.10a (Page 215) and for the Values of Bi = 0.2105 and Fo = 0.565, it is found that phi2 = 0.1
phi = phi1+phi2*(1-phi1);     //Refer eqn. 5.73a (Page 253)
T = Tc+((Ti-Tc)*(1-phi));
end Ex5_13;
//======================================================
