//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 5: Transient and Multidimensional Heat Conduction
//Example: 5.4 Page 226
//Title: Transient Heat Conduction to a Semi Infinite Region
//======================================================
model Ex5_4

//==========
//Parameter Section

parameter Real alpha(unit = "m^2/s") = 1.5e-5 "Average Thermal Diffusivity of Wrought Iron";

//==========
//Variable Section

output Real t(unit = "s") "Time for the Sword to be in a Semi-Infinite Region";
Real thalf(unit = "m") "Half-Thickness of the Sword";

//==========
//Equation Section

equation
thalf = 3e-3;                     //Assumption
t = (thalf^2)/((3.64^2)*alpha);   //Refer Page 227
//For approximately 1/20 s the Sword can be analyzed as Semi-Infinite Region. The Ratio of Thermal Diffusivity of Steel to that of Clay is about 30. Time is inversely proportional to Thermal Diffusivity. Therefore, with the Clay coating, the Sword can be analyzed as Semi-Infinite Region for approximately 30/20 = 1.5 s. The maximum time or the Quench time of the Sword with the Clay coating is approximately 1.5s whereas without the clay coating, the Quench time of the Sword is only, t = 0.045s.
end Ex5_4;
//======================================================
