//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 5: Transient and Multidimensional Heat Conduction
//Example: 5.5 Page 228
//Title: Finger Burns
//======================================================
model Ex5_5

//==========
//Parameter Section

parameter Real Tb(unit = "deg C") = 65 "Burn Threshold Temperature of Human Skin";
parameter Real Thb(unit = "deg C") = 37 "Human Body Temperature";
parameter Real alpha(unit = "m^2/s") = 0.135e-6 "Thermal Diffusivity of Beef";

//==========
//Variable Section

input Real havg(unit = "W/(m^2 K)",start = 100) "Assumed Average Heat Transfer Coefficient";
input Real Tc(unit = "deg C",start = 800) "Candle Flame Temperature";
input Real K(unit = "W/(m K)",start = 0.63) "Thermal Conductivity";
output Real t(unit = "s") "Time for Human Finger to get Burnt";
Real theta "Constant of Temperature";
Real beta "Constant";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);
theta = (Tb-Tc)/(Thb-Tc);
beta^2 = (havg^2)*alpha*t/(K^2);
beta = (1-theta)*(pi^0.5)/2;
//For the Assumed Average Heat Transfer Coefficient, havg = 100 W/(m^2 K), approximately (1/3)rd of a Second is required to rise the Temperature of Human Skin from 37 deg C to 65 deg C. Therefore for the Correct Value of Average Heat Transfer Coefficient, (1/4)th of a Second is usually needed to increase the Temperature of Human Skin from 37 deg C to 65 deg C and consequently causing Burns.
end Ex5_5;
//======================================================
