//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 5: Transient and Multidimensional Heat Conduction
//Example: 5.7 Page 235
//Title: Depth of Earth
//======================================================
model Ex5_7

//==========
//Parameter Section

parameter Real alpha(unit = "m^2/s") = 0.139e-6 "Thermal Diffusivity of Coarse, Gravelly Earth";

//==========
//Variable Section

Real omega(unit = "rad/s") "Angular Velocity of Earth";
output Real x(unit = "m") "Depth of Earth at which the Particular Temperature Wave was Launched";
Real e  "constant";
Real pi "Constant";

//==========
//Equation Section

equation
pi=2*Modelica.Math.asin(1.0);   //Constant pi
omega = (2*pi)/(365*24*3600);
tan(pi-e) = 1;
//The Minimum Positive Value of tan(-e) = 1, is e = 3*pi/4
x*((omega/(2*alpha))^0.5) = 3*pi/4;      //Refer Page 236
end Ex5_7;
//======================================================
